<?php

declare(strict_types=1);

namespace Erlage\Photogram\Tools\Fso\Disk;

class DiskLocal implements InterfaceDisk
{
    public function write(string $objectId, string $contents): void
    {
        \file_put_contents(DIR_PATH_UPLOADS . $objectId, $contents);
    }

    public function read(string $objectId): string
    {
        return \file_get_contents(DIR_PATH_UPLOADS . $objectId);
    }

    public function delete(string $objectId): void
    {
        @\unlink(DIR_PATH_UPLOADS . $objectId);
    }

    public function publicUrl(string $objectId): string
    {
        return SERVER_URL . DIR_NAME_UPLOADS . DIRECTORY_SEPARATOR . $objectId;
    }
}
